/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.Map;

public class TimeManagerPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYTMPT";
    private static final String TRACE_MASKF = "XNTYTMPF";
    private static final String TRACE_MASKD = "XNTYTMPD";
    private transient ItemDescriptor[] m_idTimeTable;
    private transient ColumnDescriptor[] m_cdTimeTableStructure;
    private int[] m_iTimeTableSelection;
    private Map data;
    public static final String TIME_TABLE = "TimeTable";
    public static final String TASKLET_SELECTED_TIMES = "TaskletSelectedTimes";
    public static final String EDIT_MODE = "EditMode";

    public void setTimeTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        }
        this.m_iTimeTableSelection = selected;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "TimeManagerPanel");
        String time = null;
        String[] times = null;
        if (this.m_iTimeTableSelection != null && this.m_iTimeTableSelection.length > 0) {
            Map[] timesMaps = (Map[])this.data.get(TIME_TABLE);
            times = new String[this.m_iTimeTableSelection.length];
            for (int i = 0; i < this.m_iTimeTableSelection.length; ++i) {
                times[i] = (String)timesMaps[this.m_iTimeTableSelection[i]].get("DataMapUserName");
            }
            time = times[0];
        } else {
            time = "";
            times = new String[]{};
        }
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setData(TASKLET_SELECTED_TIMES, times);
            request.setData("CommandName", "OKButton");
        } else if (command.equals(this.getMountPrefix() + "AddButton")) {
            request.setData("CommandName", "AddButton");
        } else if (command.equals(this.getMountPrefix() + "EditButton")) {
            if (time.equals("")) {
                request = null;
            } else {
                request.setData("CommandName", "EditButton");
                request.setData(TASKLET_SELECTED_TIMES, time);
            }
        } else if (command.equals(this.getMountPrefix() + "DeleteButton")) {
            if (time.equals("")) {
                request = null;
            } else {
                request.setData("CommandName", "DeleteButton");
                request.setData(TASKLET_SELECTED_TIMES, time);
            }
        }
        if (request != null) {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object o) {
        Trace.trace(TRACE_MASKT, "<> update");
        if (o instanceof Map) {
            Map map = (Map)o;
            String command = (String)map.get("CommandName");
            Map[] times = (Map[])this.data.get(TIME_TABLE);
            if (command.equals("DeleteButton")) {
                Map[] newTimes = new Map[times.length - 1];
                System.arraycopy(times, 0, newTimes, 0, this.m_iTimeTableSelection[0]);
                System.arraycopy(times, this.m_iTimeTableSelection[0] + 1, newTimes, this.m_iTimeTableSelection[0], newTimes.length - this.m_iTimeTableSelection[0]);
                this.data.put(TIME_TABLE, newTimes);
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + TIME_TABLE, new int[0]);
                this.setTimeTableSelection(new int[0]);
            } else if (command.equals("AddButton")) {
                Map[] newTimes = new Map[times.length + 1];
                System.arraycopy(times, 0, newTimes, 0, times.length);
                HashMap newTime = new HashMap();
                newTime.put("DataMapUserName", map.get("DataMapUserName"));
                newTime.put("DataMapDesc", map.get("DataMapDesc"));
                newTimes[times.length] = newTime;
                this.data.put(TIME_TABLE, newTimes);
            } else if (command.equals("EditButton")) {
                times[this.m_iTimeTableSelection[0]].put("DataMapUserName", map.get("DataMapUserName"));
                times[this.m_iTimeTableSelection[0]].put("DataMapDesc", map.get("DataMapDesc"));
            }
            this.userTaskManager.refreshAllElements();
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        String[] selectedTimes = (String[])this.data.get(TASKLET_SELECTED_TIMES);
        if (selectedTimes == null) {
            selectedTimes = new String[]{};
        }
        int[] selectedTimeIndicies = new int[selectedTimes.length];
        int selectedTimeIndex = 0;
        Map[] times = (Map[])this.data.get(TIME_TABLE);
        if (times == null) {
            this.data.put(TIME_TABLE, new Map[0]);
        }
        if (times != null) {
            for (int i = 0; i < times.length; ++i) {
                if (times[i] == null) continue;
                for (int j = 0; j < selectedTimes.length; ++j) {
                    if (!selectedTimes[j].equals((String)times[i].get("DataMapUserName"))) continue;
                    selectedTimeIndicies[selectedTimeIndex++] = i;
                    j = selectedTimes.length;
                }
            }
            if (selectedTimeIndex >= 0) {
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + TIME_TABLE, (int[])selectedTimeIndicies.clone());
                this.m_iTimeTableSelection = (int[])selectedTimeIndicies.clone();
            } else {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
            }
        } else {
            this.data.put(TIME_TABLE, new Map[0]);
        }
        Boolean editMode = (Boolean)this.data.get(EDIT_MODE);
        if (editMode == null) {
            editMode = Boolean.FALSE;
        }
        if (editMode.booleanValue()) {
            Trace.trace(TRACE_MASKF, "TimeManagerPanelBean: edit mode");
            this.userTaskManager.setShown(this.getMountPrefix() + "OKButton", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "CancelButton", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "HelpButton", false);
        } else {
            Trace.trace(TRACE_MASKF, "TimeManagerPanelBean: non-edit mode");
            this.userTaskManager.setShown(this.getMountPrefix() + "AddButton", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "EditButton", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "DeleteButton", false);
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        this.m_idTimeTable = new ItemDescriptor[0];
        this.m_cdTimeTableStructure = new ColumnDescriptor[0];
        this.m_iTimeTableSelection = new int[0];
        if (this.data == null) {
            this.data = new HashMap();
        }
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getTimeTableRowCount() {
        Map[] times = (Map[])this.data.get(TIME_TABLE);
        return times.length;
    }

    public ItemDescriptor[] getTimeTableRowAt(int index) {
        Map[] times = (Map[])this.data.get(TIME_TABLE);
        ItemDescriptor col1 = new ItemDescriptor(this.getMountPrefix() + "name_" + index, (String)times[index].get("DataMapUserName"));
        ItemDescriptor col2 = new ItemDescriptor(this.getMountPrefix() + "desc_" + index, (String)times[index].get("DataMapDesc"));
        return new ItemDescriptor[]{col1, col2};
    }

    public ColumnDescriptor[] getTimeTableRowStructure() {
        return this.m_cdTimeTableStructure;
    }

    public int getTimeTableRowStatus() {
        return 3;
    }

    public void setTimeTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idTimeTable = items;
    }

    public int[] getTimeTableSelection() {
        return this.m_iTimeTableSelection;
    }
}

